<?php

use Interop\Http\ServerMiddleware\DelegateInterface;
use Interop\Http\ServerMiddleware\MiddlewareInterface;
use Psr\Http\Message\ServerRequestInterface;

class RemoveDevPrefixMiddleware implements MiddlewareInterface
{
    private $prefix;

    public function __construct(string $prefix = '/extra_directory')
    {
        $this->prefix = $prefix;
    }

    public function process(ServerRequestInterface $request, DelegateInterface $delegate)
    {
        $uri = $request->getUri();
        $path = $uri->getPath();
        $path = preg_replace('#^' . $this->prefix . '#', '', $path);

        $uri = $uri->withPath($path);
        return $delegate->process($request->withUri($uri));
    }
}