#!/bin/bash
# Launch Logseq and/or raise it.
#
# In all cases, it raises it on the current workspace, and positions it on the
# right half of the screen. Change the logic in get_width(), get_height(), and
# get_geometry() to change positioning and size.
#
# I bind this to <Super><Ctrl>-l, which allows me to launch it at any time.

get_width() {
    local full_width
    local half_width
    full_width="$(wmctrl -d | grep "\*" | cut -d' ' -f 5 | cut -d'x' -f1)"

    half_width=$((full_width/2))
    echo $half_width
}

get_height() {
    wmctrl -d | grep "\*" | cut -d' ' -f 5 | cut -d'x' -f2
}

get_geometry() {
    local width
    local height

    width=$(get_width)
    height=$(get_height)

    # 100 puts it at a higher z-axis plane, which should put it above other windows
    echo "100,${width},0,${width},${height}"
}

is_logseq_running() {
    if ! wmctrl -x -l | grep -q "logseq.Logseq"; then
        return 1
    fi

    return 0
}

if ! is_logseq_running; then
    # This launches logseq, and detaches it from this script's process
    logseq & disown

    # The wm_class is not set immediately on launch, so we need to sleep for a
    # moment before positioning. 2 seconds seems to be the sweet spot
    sleep 2
fi

wmctrl -x -R "logseq.Logseq"
wmctrl -x -a "logseq.Logseq"
wmctrl -x -r "logseq.Logseq" -e "$(get_geometry)"