<?php

// In a module class somewhere...
use Zend\EventManager\LazyListener;
use Zend\Mvc\MvcEvent;

class Module
{
    public function onBootstrap(MvcEvent $e)
    {
        $app = $e->getApplication();
        $services = $app->getServiceManager();
        $events = $app->getEventManager();

        $listener = new LazyListener([
            'listener' => YourShortCircuitingListener::class,
            'method'   => '__invoke',
        ], $services);
        
        $events->attach(MvcEvent::EVENT_ROUTE, $listener, PHP_INT_MAX);
    }
}

// And now for the listener...
class YourShortCircuitingListener
{
    public function __invoke(MvcEvent $e)
    {
        $request = $e->getRequest();
        if (/* some criteria that, if met, means we should continue normal operation */) {
            return;
        }

        // At this point, we know we want to short-circuit
        $response = $e->getResponse();

        // populate the response

        return $response;
    }
}