local wezterm = require 'wezterm'

wezterm.on(
    'format-tab-title',
    function(tab, tabs, panes, config, hover, max_width)
        if tab.is_active then
            -- Do nothing; normal active style is fine, so just return the text
            return tab.active_pane.title
        end

        local has_unseen_output = false

        for _, pane in ipairs(tab.panes) do
            if pane.has_unseen_output then
                has_unseen_output = true
                break
            end
        end

        if has_unseen_output then
            -- Set the background to Solarized's yellow, and foreground to
            -- Solarized's base02
            return {
                { Background = { Color = '#b58900' } },
                { Foreground = { Color = '#073642' } },
                { Text = ' ' .. tab.active_pane.title .. ' ' },
            }
        end

        -- Do nothing different, as there's no activity; just return the text
        return tab.active_pane.title
    end
)