<?php

use Zend\ServiceManager\DelegatorFactoryInterface;
use Zend\ServiceManager\ServiceLocatorInterface;

/**
 * Delegator factory for adding the CompositeAdapter.
 *
 * This delegator factory assumes that you've registered the CompositeAdapter
 * as the service 'CompositeAdapter'.
 *
 * Attach it to the DefaultAuthenticationListener using:
 *
 * ```php
 * 'service_manager' => array(
 *     'delegators' => array(
 *         'ZF\MvcAuth\Authentication\DefaultAuthenticationListener' => array(
 *             'CompositeAdapterDelegatorFactory',
 *         ),
 *     ),
 * ),
 * ```
 */
class CompositeAdapterDelegatorFactory implements DelegatorFactoryInterface
{
    public function createDelegatorWithName(
        ServiceLocatorInterface $services,
        $name,
        $requestedName,
        $callback
    ) {
        $listener = $callback();

        $composite = $services->get('CompositeAdapter');
        $listener->attach($composite);
        return $listener;
    }
}