<?php

declare(strict_types=1);

namespace SomeModule;

use Mezzio\MiddlewareFactory;
use Mezzio\Router\Route;
use Mezzio\Router\RouteCollectorInterface;
use Psr\Http\Server\MiddlewareInterface;
use Psr\Http\Server\RequestHandlerInterface;

class RouteCollector implements RouteCollectorInterface
{
    public function __construct(
        private RouteCollectorInterface $collector,
        private MiddlewareFactory $factory,
    ) {
    }

    /**
     * @param non-empty-string $path
     * @param null|list<string> $methods HTTP method to accept; null indicates any.
     * @param null|non-empty-string $name The name of the route.
     */
    public function route(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?array $methods = null,
        ?string $name = null
    ): Route {
        return $this->collector->route($path, $this->factory->prepare($middleware), $methods, $name);
    }

    /**
     * @param non-empty-string $path
     * @param null|non-empty-string $name The name of the route.
     */
    public function get(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?string $name = null
    ): Route {
        return $this->collector->get($path, $this->factory->prepare($middleware), $name);
    }

    /**
     * @param non-empty-string $path
     * @param null|non-empty-string $name The name of the route.
     */
    public function post(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?string $name = null
    ): Route {
        return $this->collector->post($path, $this->factory->prepare($middleware), $name);
    }

    /**
     * @param non-empty-string $path
     * @param null|non-empty-string $name The name of the route.
     */
    public function put(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?string $name = null
    ): Route {
        return $this->collector->put($path, $this->factory->prepare($middleware), $name);
    }

    /**
     * @param non-empty-string $path
     * @param null|non-empty-string $name The name of the route.
     */
    public function patch(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?string $name = null
    ): Route {
        return $this->collector->patch($path, $this->factory->prepare($middleware), $name);
    }

    /**
     * @param non-empty-string $path
     * @param null|non-empty-string $name The name of the route.
     */
    public function delete(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?string $name = null
    ): Route {
        return $this->collector->delete($path, $this->factory->prepare($middleware), $name);
    }

    /**
     * @param non-empty-string $path
     * @param null|non-empty-string $name The name of the route.
     */
    public function any(
        string $path,
        string|array|callable|MiddlewareInterface|RequestHandlerInterface $middleware,
        ?string $name = null
    ): Route {
        return $this->collector->route($path, $this->factory->prepare($middleware), null, $name);
    }

    /**
     * Retrieve all directly registered routes with the application.
     *
     * @return list<Route>
     */
    public function getRoutes(): array
    {
        return $this->collector->getRoutes();
    }
}