<?php

namespace SomeModule;

use Laminas\Stdlib\ArrayUtils\MergeRemoveKey;
use Mezzio\Router\RouteCollectorInterface;

class ConfigProvider
{
    public function getConfig(): array
    {
        return [
            'dependencies' => $this->getDependencies(),
        ];
    }

    public function getDependencies(): array
    {
        return [
            'aliases'    => [
                RouteCollectorInterface::class => new MergeRemoveKey(),
            ],
            'factories'  => [
                RouteCollectorInterface::class => RouteCollectorFactory::class,
            ],
            'delegators' => [
                RouteCollectorInterface::class => [
                    RegisterRoutesFactory::class,
                ],
            ],
        ];
    }
}