<?php

namespace SomeModule;

use Mezzio\MiddlewareFactory;
use Mezzio\Router\RouteCollector as MezzioRouteCollector;
use Psr\Container\ContainerInterface;

use function assert;

class RouteCollectorFactory
{
    public function __invoke(ContainerInterface $container): RouteCollector
    {
        $collector = $container->get(MezzioRouteCollector::class);
        assert($collector instanceof MezzioRouteCollector);

        $factory = $container->get(MiddlewareFactory::class);
        assert($factory instanceof MiddlewareFactory);

        return new RouteCollector($collector, $factory);
    }
}